# Growfi - Full Ready Prototype (Sponsor-ID Registration + Admin)

## Overview
This is a ready prototype with:
- User registration that **requires a Sponsor ID** (must be an existing user_code).
- Login using **User Code (Sponsor ID / your own user code)** + password.
- Basic Admin panel (requires admin flag on user) to view users.
- PHP + MySQL based, uses PDO and prepared statements.

## Setup (local with XAMPP / LAMP)
1. Copy the `public/` folder into your web root (e.g., `htdocs/growfi/public`). Keep `api/` and `admin/` at same level so paths work, or adjust paths in `api/db.php`.
2. Edit `api/db.php` and set DB credentials.
3. Import SQL: open `sql/schema.sql` and `php sql/create_hashes.php` to generate password hashes:
   - Run `php sql/create_hashes.php` to print hashes for the seeded admin and sponsor users.
   - Replace `REPLACE_WITH_HASH_SPONSOR` and admin placeholder in `sql/schema.sql` with the printed hashes.
   - Import `sql/schema.sql` via phpMyAdmin or `mysql` CLI.
4. Start Apache + MySQL and open `http://localhost/growfi/public/index.php`.

## Credentials (after you generate hashes)
- Admin user code: `ADMIN001` (password: `adminpass123` if you used helper)
- Sponsor sample: `SPONSOR01` (password: `sponsor123`)

## How Sponsor-based registration works
- To register, a new user must provide a valid Sponsor ID (an existing `user_code`).
- The system generates a unique `user_code` like `GROWFIA1B2C3` and stores sponsor_code linking to the sponsor.
- Login can be done using your `user_code` (or the sponsor id if you have it) along with password.

## Next steps I can implement for you (ask and I'll add):
- Auto email/SMS verification, referral tree visualization, payouts and withdrawal flows, KYC, payment gateway integration, enhanced admin actions, Dockerfile for easy deployment.

**Important:** This is a prototype. For production, implement HTTPS, input validation across all endpoints, rate limiting, and legal compliance for MLM operations.
