-- Growfi MySQL schema and seed data
CREATE DATABASE IF NOT EXISTS growfi_production;
USE growfi_production;

DROP TABLE IF EXISTS users;
CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_code VARCHAR(100) UNIQUE NOT NULL,
  sponsor_code VARCHAR(100),
  password_hash VARCHAR(255) NOT NULL,
  is_admin TINYINT(1) DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

DROP TABLE IF EXISTS wallets;
CREATE TABLE wallets (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  balance DECIMAL(18,6) DEFAULT 0,
  staking DECIMAL(18,6) DEFAULT 0,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Seed admin user (password: adminpass123)
INSERT INTO users (user_code, sponsor_code, password_hash, is_admin) VALUES
('ADMIN001', NULL, '""', 1);

-- We'll replace the hash below with a real PHP compatible hash after creation instructions.
-- Also create a sample sponsor user (password: sponsor123)
INSERT INTO users (user_code, sponsor_code, password_hash, is_admin) VALUES
('SPONSOR01', 'ADMIN001', 'REPLACE_WITH_HASH_SPONSOR', 0);

-- Note: After import, update the password_hash fields to real hashes using PHP's password_hash() or run the included helper script.
