<?php
session_start();
require_once __DIR__.'/../api/db.php';

$err = '';
if($_SERVER['REQUEST_METHOD'] === 'POST'){
  $sponsor_id = trim($_POST['sponsor_id']);
  $password = $_POST['password'];

  if($sponsor_id==='' || $password==='') $err='All fields required.';

  if(!$err){
    $stmt = $pdo->prepare('SELECT id FROM users WHERE user_id = ? LIMIT 1');
    $stmt->execute([$sponsor_id]);
    $sponsor = $stmt->fetch(PDO::FETCH_ASSOC);
    if(!$sponsor){
      $err = 'Invalid Sponsor ID. Provide a valid existing Sponsor/User ID.';
    } else {
      $user_id = 'GROWFI'.strtoupper(substr(bin2hex(random_bytes(3)),0,6));
      $hash = password_hash($password, PASSWORD_DEFAULT);
      $ins = $pdo->prepare('INSERT INTO users (sponsor_id, user_id, password, role, status) VALUES (?, ?, ?, "user", "active")');
      $ins->execute([$sponsor_id, $user_id, $hash]);
      $uid = $pdo->lastInsertId();
      $pdo->prepare('INSERT INTO wallet (user_id) VALUES (?)')->execute([$user_id]);
      $_SESSION['user_id'] = $uid;
      $_SESSION['user_code'] = $user_id;
      $_SESSION['is_admin'] = 0;
      header('Location: dashboard.php');
      exit;
    }
  }
}
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Growfi - Register</title>
<link rel="stylesheet" href="css/style.css"></head><body>
<div class="container">
  <div class="card auth">
    <h2>Growfi Registration</h2>
    <?php if($err):?><div class="error"><?=htmlspecialchars($err)?></div><?php endif; ?>
    <form method="post">
      <label>Sponsor ID</label>
      <input name="sponsor_id" placeholder="Enter Sponsor ID (required)" required>
      <label>Create Password</label>
      <input name="password" type="password" placeholder="Choose a secure password" required>
      <button type="submit">Register</button>
    </form>
    <p>Already a member? <a href="index.php">Login</a></p>
  </div>
</div>
</body></html>